/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.command;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import org.cyclops.integrateddynamics.core.test.IntegrationBefore;
import org.cyclops.integrateddynamics.core.test.IntegrationTest;

public class CommandTest
implements Command<CommandSourceStack> {
    private static final String P = "org.cyclops.integrateddynamics.core.evaluate.variable.integration.";
    public static final List<String> CLASSES = ImmutableList.of((Object)"org.cyclops.integrateddynamics.core.evaluate.variable.integration.TestVariables", (Object)"org.cyclops.integrateddynamics.core.evaluate.variable.integration.TestBlockOperators", (Object)"org.cyclops.integrateddynamics.core.evaluate.variable.integration.TestItemStackOperators", (Object)"org.cyclops.integrateddynamics.core.evaluate.variable.integration.TestEntityOperators", (Object)"org.cyclops.integrateddynamics.core.evaluate.variable.integration.TestFluidStackOperators", (Object)"org.cyclops.integrateddynamics.core.evaluate.variable.integration.TestIngredientsOperators", (Object)"org.cyclops.integrateddynamics.core.evaluate.variable.integration.TestRecipeOperators");

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ((CommandSourceStack)context.getSource()).m_81375_().m_6352_((Component)new TextComponent("Running tests..."), Util.f_137441_);
        try {
            if (!this.test()) {
                ((CommandSourceStack)context.getSource()).m_81375_().m_6352_((Component)new TextComponent("There were failing tests, see results in console."), Util.f_137441_);
            } else {
                ((CommandSourceStack)context.getSource()).m_81375_().m_6352_((Component)new TextComponent("All tests succeeded!"), Util.f_137441_);
            }
            return 0;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return 1;
        }
    }

    protected boolean test() throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        int ok = 0;
        int total = 0;
        for (String className : CLASSES) {
            Class<?> clazz = Class.forName(className);
            Object testInstance = clazz.newInstance();
            LinkedList befores = Lists.newLinkedList();
            HashMap tests = Maps.newHashMap();
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.isAnnotationPresent(IntegrationBefore.class)) {
                    befores.add(method);
                }
                if (!method.isAnnotationPresent(IntegrationTest.class)) continue;
                tests.put(method, false);
            }
            for (Method test : tests.keySet()) {
                boolean testOk;
                String testName = className.replace(P, "") + "#" + test.getName();
                for (Method before : befores) {
                    before.invoke(testInstance, new Object[0]);
                }
                try {
                    test.invoke(testInstance, new Object[0]);
                    testOk = true;
                }
                catch (InvocationTargetException e) {
                    Class<?> excepted = test.getAnnotation(IntegrationTest.class).expected();
                    if (!excepted.isInstance(e.getTargetException())) {
                        testOk = false;
                        if (e.getTargetException() instanceof IllegalStateException || e.getTargetException() instanceof AssertionError) {
                            System.err.println("Test " + testName + " failed!");
                            e.getTargetException().printStackTrace();
                        } else {
                            System.err.println(String.format("Expected at %s exception %s, but found:", testName, e));
                            e.getTargetException().printStackTrace();
                        }
                    }
                    testOk = true;
                }
                tests.put(test, testOk);
            }
            for (Boolean result : tests.values()) {
                if (!result.booleanValue()) continue;
                ++ok;
            }
            total += tests.size();
        }
        System.err.println(String.format("Tests succeeded: %s/%s", ok, total));
        return ok == total;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> make() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"test").requires(commandSource -> commandSource.m_6761_(2))).executes((Command)new CommandTest());
    }
}

